#include <bits/stdc++.h>
#include <sys/wait.h>
#include <unistd.h>

using namespace std;

class spawn {
  int write_pipe[2];
  int read_pipe[2];
  int child_pid;
  public:
  spawn(char * const argv[]) {
    if (pipe(write_pipe) == -1) throw runtime_error("Failed to create pipe");
    if (pipe(read_pipe) == -1) throw runtime_error("Failed to create pipe");
    child_pid = fork();
    if (child_pid == -1) throw runtime_error("Failed to fork process");
    if (child_pid == 0) { // in child
      if (dup2(write_pipe[0], STDIN_FILENO) == -1) throw runtime_error("Failed to dup handle");
      if (dup2(read_pipe[1], STDOUT_FILENO) == -1) throw runtime_error("Failed to dup handle");
      if (close(write_pipe[0]) == -1) throw runtime_error("Failed to close handle");
      if (close(write_pipe[1]) == -1) throw runtime_error("Failed to close handle");
      if (close(read_pipe[0]) == -1) throw runtime_error("Failed to close handle");
      if (close(read_pipe[1]) == -1) throw runtime_error("Failed to close handle");
      if (execv(argv[0], argv) == -1) {
        cerr << "Error: Failed to launch program\n";
        exit(1);
      }
    } else { // in parent
      if (close(write_pipe[0]) == -1) throw runtime_error("Failed to close handle");
      if (close(read_pipe[1]) == -1) throw runtime_error("Failed to close handle");
      signal(SIGPIPE, SIG_IGN); // 
    }
  }

  bool send_line(const char *fmt, ...) {
    char buf[2000];
    va_list ap;
    va_start(ap, fmt);
    int n = vsnprintf(buf, sizeof(buf), fmt, ap);
    va_end(ap);
    return write(write_pipe[1], buf, n) == n;
  }

  bool send_eof() {
    return close(write_pipe[1]) != -1;
  }

  bool recv_line(char buf[], int size) {
    for (int n = 0; n + 1 < size; ++n) {
      int m = read(read_pipe[0], buf + n, 1);
      if (m < 0) {
        return false;
      }
      if (m == 0) {
        buf[n] = 0;
        return true;
      }
      if (buf[n] == '\n') {
        buf[n] = 0;
        return true;
      }
    }
    buf[size - 1] = 0;
    return true;
  }

  int wait() {
    int status;
    waitpid(child_pid, &status, 0);
    return status;
  }
};

const int MAX_GUESSES = 30;

int main(int argc, char * const argv[]) {
  if (argc < 3) {
    cerr << "Usage:" << endl;
    cerr << argv[0] << " inputfile program [args...]" << endl;
    return 2;
  }
  ifstream inputfile(argv[1]);
  long x;
  inputfile >> x;

  int guesses = 0;
  spawn ch = spawn(argv + 2);
  while (true) {
    char buf[20];
    if (!ch.recv_line(buf, 20)) {
      cerr << "Unexpected end of output" << endl;
      return 1;
    }
    cout << buf << endl;
    stringstream ss(buf);
    char c;
    ss >> c;
    if (c == '?') {
      guesses++;
      if (guesses > MAX_GUESSES) {
        cerr << "Too many guesses" << endl;
        return 1;
      }
      long q;
      ss >> q;
      if (q > x) {
        cout << "10-4" << endl;
        ch.send_line("10-4\n");
      } else {
        cout << "QAQ" << endl;
        ch.send_line("QAQ\n");
      }
    } else if (c == '!') {
      long q;
      ss >> q;
      if (q == x) {
        cerr << "Correct (" << guesses << " guesses)" << endl;
        return 0;
      } else {
        cerr << "Incorrect" << endl;
        return 1;
      }
    } else {
      cerr << "Expected ? or !" << endl;
      return 1;
    }
  }
}
